// noneNavigation　ページャーもナビも無し
// disabled　タッチ操作も全て無効
// '__sp' '--sp'　スマホの時のみ


// フェードインスライドショー 
// ナビゲーションやページネーション無し、タッチスクロール無効
// 5秒で2秒かけて切り替わる
const slideFade__disabled = new Swiper(".slideFade__disabled.swiper", {
  // effect: 'fade',
  // loop: true,
  // slidesPerView: 1,
  // autoplay: {
  //   delay: 4000,
  //   disableOnInteraction: false,
  //   waitForTransition: false,
  // },
  // allowTouchMove: false,
  // speed: 2000,
  loop: true,
  effect: "fade", // フェード切り替え
  // 自動再生
  autoplay: {
    delay: 4000, // 4秒後に次のスライドへ
    disableOnInteraction: false, // ユーザーが操作しても自動再生を継続
  },
  speed: 2000, // 2秒かけてフェード
});

const slide__noneNavigation = new Swiper(".slide__noneNavigation.swiper", {
  loop: true,
  slidesPerView: 1,
  autoplay: {
    delay: 6000,
    disableOnInteraction: false,
    waitForTransition: false,
  },
  speed: 1000,
});

const swiper = new Swiper('.slider__column.swiper', {
  centeredSlides: true,
  loop: true,
  speed: 500,
  spaceBetween: 10,
  autoplay: {
    delay: 3000,
    disableOnInteraction: false,
    waitForTransition: false,
  },
  navigation: {
      nextEl: '.swiper-button-next',
      prevEl: '.swiper-button-prev',
  },
  breakpoints: {
    768: {
        spaceBetween: 40,
    },
    1024: {
        spaceBetween: 60,
    }
  },
});

// ステップ
// サムネイル
const sliderThumbnail = new Swiper(".stepUpper.swiper", {
  slidesPerView: 3, // サムネイルの枚数
});
// スライダー
const slider = new Swiper(".stepCts.swiper", {
  // 前後の矢印
  centeredSlides: true,
  spaceBetween: 24,
  navigation: {
    nextEl: ".swiper-button-next",
    prevEl: ".swiper-button-prev",
  },
  thumbs: {
    swiper: sliderThumbnail,
  },
  breakpoints: {
    500: {
      spaceBetween: 50,
    },
    768: {
      spaceBetween: 80,
    }
  },
});


$(function(){

  let wWidth = $(window).width();
  let wHeight = window.innerHeight;
  const wSm = 1024;
  // 画面幅が1024以上だったら
  if (wWidth >= wSm) {
    }else{
      const slideNav__noneNavigation__sp = new Swiper(".slideNav__noneNavigation--sp.swiper", {
        slidesPerView: 1,
        grabCursor: true,
        breakpoints: {
          600: {
            slidesPerView: 2,
          }
        },
      });
  }

});

