$(function(){

  $('a[href^="#link-"]').click(function() {
    var speed = 1000;
    var href = $(this).attr('href');
    var target = $(href == '#' || href == '' ? 'html' : href);
    // ヘッダーの高さ+30pxの位置を取得
    var position = target.offset().top;
    $('html, body').animate({scrollTop: position}, speed, 'swing');
    return false;
  });

  let wWidth = $(window).width();
  let wHeight = window.innerHeight;
  const wSm = 1024;
  const wTm = 768;

  const isPC = wWidth >= wSm;// isPCは、画面幅1024を軸に値を変える
  const isTB = wWidth >= wTm;// isTBは、画面幅768を軸に値を変える

  const param = {
    animation: isTB ? 0.2 : 0.1,
    // parallaxScrollY: isPC ? -100 : -50,
    // parallaxScrollScrub: isPC ? 0.5 : 0.3,
  };

  /// ◼︎◼︎ ページ内の.animationを全て取得する
  const animationNumber = $('.animation').length;
  const animationFlagList = [...Array(animationNumber)].map(() => false);

  function animationEvent() {
    /// ◼︎◼︎ scrollにスクロールするごとにページTOPからの値を入れていく ◼︎◼︎
    let scroll = $(window).scrollTop();
    // ◼︎◼︎ .animationの上部の値を取得し、画面に表示されたタイミングで.onというクラスを追加する ◼︎◼︎
    $('.animation').each(function(index){
      let animatioTh = $(this);
      let animation__timing = animatioTh.offset().top - (wHeight - (wHeight * param.animation));
      if (scroll >= animation__timing && animationFlagList[index] !== true){
        animationFlagList[index] = true;
        animatioTh.addClass('on');
      }
    });
  }
  
  animationEvent();

  $(window).on('scroll', function () {

    animationEvent();

    // ＊＊＊＊＊＊ スクロールアクションあれこれ▼ ＊＊＊＊＊＊

    // ◼︎◼︎ 少しスクロールしたらbodyに.scrollStartを追加する ◼︎◼︎
    if ($(this).scrollTop() > 50) {
      $('body').addClass('scroll-start');
    }else{
      $('body').removeClass('scroll-start');
    }
    
    // ＊＊＊＊＊＊ スクロールアクションあれこれ▲ ＊＊＊＊＊＊
  });

  // ＊＊＊＊＊＊ ハンバーガーメニュー▼ ＊＊＊＊＊＊
  let navParent = $('#js-modal .parent');
  let navChildren = navParent.next('.children');

  // 以下handleがないとタッチアクションの制御ができない
  const handle = (event) => {
    event.preventDefault();
  }
  // ◼︎◼︎ ハンバーガーメニューをクリックした時のアクション ◼︎◼︎
  $('#js-modal-btn').on('click',function(){
    $('header').toggleClass('active');
    if($('header').hasClass('active')){
      // navChildren.removeClass('open').hide();
      navChildren.hide();
      navParent.removeClass('active');
      // document.addEventListener('touchmove', handle, { passive: false });
      // document.addEventListener('mousewheel', handle, { passive: false });
    }else{
      // document.removeEventListener('touchmove', handle, { passive: false });
      // document.removeEventListener('mousewheel', handle, { passive: false });
    }
  });

  // ◼︎◼︎ 親要素をクリックしたら子要素が表示される処理 ◼︎◼︎
  navChildren.hide();
  // navChildren.removeClass('.open').hide();
  navParent.on('click',function(){
    // $(this).next().toggleClass('open');
    $(this).next().slideToggle();
    $(this).toggleClass('active');
  });

  // ◼︎◼︎ ハンバーガーメニュー内のリンクをクリックしたらモーダルが閉じる ◼︎◼︎
  let navItem = $('#js-modal a');
  navItem.on('click',function(){
    $('header').removeClass('active');
    navChildren.removeClass('open').hide();
    navParent.removeClass('active');
    navChildren.removeClass('open');
    document.removeEventListener('touchmove', handle, { passive: false });
    document.removeEventListener('mousewheel', handle, { passive: false });
  });
  // ＊＊＊＊＊＊ ハンバーガーメニュー▲ ＊＊＊＊＊＊
  
});