<?php
  ini_set( 'display_errors', 1 );

  define( "DIR_NAME", basename(dirname(__FILE__)));
  include($_SERVER['DOCUMENT_ROOT'].'/inc/data.php');
  include($_SERVER['DOCUMENT_ROOT'].'/inc/config.php');

  define( "PAGE_TITLE" , '') ;
  define( "PAGE_DESC" , DATA_NAME .'です。募集要項、' .DATA_NAME . 'の店舗情報など、詳しい採用情報をご覧いただけます。') ;
?>
<?php
  $plugIn__css = array('swiper-bundle.min','magnific-popup');
  $plugIn__js = array('swiper-bundle.min','magnific-popup');
  $js = array('index','accordion','popup');
?>
<?php
  include($_SERVER['DOCUMENT_ROOT'].'/head.php');
  echo "\n";
?>

<?php
$css__url = $_SERVER['DOCUMENT_ROOT']. '/css/' . PAGE_PASS .'.css';
// CSSファイルが存在するかチェックする
if (file_exists($css__url)) {
    echo '<link rel="stylesheet" href="/css/'. PAGE_PASS .'.css">';
} else {
    echo '<!-- ページ固有のCSSはありません -->'."\n";
}
?>

<!-- ▼タグいれる場所 -->
<!-- ▲タグいれる場所 -->

</head>

<body class="p-<?php echo PAGE_PASS ;?> p-r">


<!--  -----------------------------------------
  SVG
------------------------------------------  -->
<?php
  include($_SERVER['DOCUMENT_ROOT'].'/svg.php');
  echo "\n";
?>


<div class="loading">
  <div class="loading-cts w-100per h-80vh-sp h-100vh-tpc h-max800-pc f-container a-c j-c">
    <div class="w-max200-sp w-max350-tpc w-60per p-r z-50 t-c">
      <h1 class="svgc-base">
        <svg viewBox="0 0 341.2 80.7">
          <use  xlink:href="#logo"></use>
        </svg>
      </h1>
      <p class="fc-base fw-b fs-12-sp fs-24-tpc mt-10"><?php echo DATA_SITE_CATCHCOPY ;?></p>
    </div>
  </div>
</div>

<div class="body-bg"><span></span></div>


<!--  -----------------------------------------
  HEADER
------------------------------------------  -->
<?php
  include($_SERVER['DOCUMENT_ROOT'].'/header.php');
  echo "\n";
?>


<main class="p-r">

<!--  -----------------------------------------
  MV
------------------------------------------  -->
<?php
$mvLists = [
  ['img' => 'MV_IMAGE1'],
  ['img' => 'MV_IMAGE2'],
  ['img' => 'MV_IMAGE3'],
  ['img' => 'MV_IMAGE4'],
  ['img' => 'MV_IMAGE5'],
];

$mvCount = 0;
foreach ($mvLists as $mvList) {
  $imgNumber = $mvList['img'];
    if (defined($imgNumber) && constant($imgNumber) !== ""){
        $mvCount++;
    }
}
?>
<section class="mv p-r">
<div class="mv-inner p-r z-0">

<?php if ($mvCount === 0) : ?>
<div class="p-a p-initial w-100per h-80vh-sp h-100vh-tpc h-max800-pc">
  <a href="">
    <picture>
      <!-- 1024px以上の画面幅の場合の画像 -->
      <source media="(min-width: 1024px)" srcset="./img/<?php echo MV_NOIMAGE_SELECT ;?>-pc.jpg">
      <!-- デフォルトの画像 -->
      <img class="w-100per h-80vh-sp h-100vh-tpc h-max800-pc" src="./img/<?php echo MV_NOIMAGE_SELECT ;?>-sp.jpg" alt="<?php echo DATA_SITE_TITLE; ?>のイメージ画像">
    </picture>
  </a>
</div>
<?php elseif ($mvCount === 1) : ?>
<?php foreach ($mvLists as $mvList) :
  if (defined($mvList['img']) && constant($mvList['img']) !== ""): ?>
<div class="p-a p-initial w-100per h-80vh-sp h-100vh-tpc h-max800-pc">
  <a href="">
    <picture>
      <!-- 1024px以上の画面幅の場合の画像 -->
      <source media="(min-width: 1024px)" srcset="./img/<?php echo constant($mvList['img']); ?>-pc.jpg">
      <!-- デフォルトの画像 -->
      <img class="w-100per h-80vh-sp h-100vh-tpc h-max800-pc" src="./img/<?php echo constant($mvList['img']); ?>-sp.jpg" alt="<?php echo DATA_SITE_TITLE; ?>のイメージ画像">
    </picture>
  </a>
</div>
<?php endif; endforeach; ?>
<?php else :?>
<div class="swiper mv-slide p-a p-initial w-100per h-80vh-sp h-100vh-tpc h-max800-pc">
<ul class="swiper-wrapper mv-slide-list">
  <?php foreach ($mvLists as $mvList) :
  if (defined($mvList['img']) && constant($mvList['img']) !== ""): ?>
  <li class="mv-slide-item swiper-slide">
    <a href="">
      <picture>
        <!-- 1024px以上の画面幅の場合の画像 -->
        <source media="(min-width: 1024px)" srcset="./img/<?php echo constant($mvList['img']); ?>-pc.jpg">
        <!-- デフォルトの画像 -->
        <img class="w-100per h-80vh-sp h-100vh-tpc h-max800-pc" src="./img/<?php echo constant($mvList['img']); ?>-sp.jpg" alt="<?php echo DATA_SITE_TITLE; ?>のイメージ画像">
      </picture>
    </a>
  </li>
  <?php endif; endforeach; ?>
  </ul>
</div>
<?php endif; ?>

<?php if ( defined( 'MV_DESIGN' ) && MV_DESIGN == "design-b" && defined( 'MV_CATCHCOPY_JP' ) && MV_CATCHCOPY_JP !== "" ) : ?>
<div class="mv-cts w-100per h-80vh-sp h-100vh-tpc h-max800-pc f-container a-end p-r">
  <h1 class="w-l w-100per pb-80-pc pb-40-tpc pb-30-sp p-r z-50 fw-n">
    <span class="db jp-accent fs-40-pc fs-38-tpc fs-24-sp fc-fff l-18">
      <?php echo MV_CATCHCOPY_JP ;?>
    </span>
    <span class="db en fc-base fs-36-pc fs-28-tpc fs-16-sp mt-25-tpc mt-20-sp">
      <?php echo MV_CATCHCOPY_EN ;?>
    </span>
  </h1>
</div>
<?php else : ?>
<div class="mv-cts w-100per h-80vh-sp h-100vh-tpc h-max800-pc f-container a-c j-c p-r">
  <div class="w-max200-sp w-max350-tpc w-60per p-r z-50 t-c">
    <h1 class="svgc-fff">
      <svg viewBox="0 0 341.2 80.7">
        <use  xlink:href="#logo"></use>
      </svg>
    </h1>
    <p class="fw-b fs-12-sp fs-24-tpc fc-fff mt-10"><?php echo DATA_SITE_CATCHCOPY ;?></p>
  </div>
</div>
<?php endif; ?>

</div>
</section>

<!--  -----------------------------------------
  CATCH
------------------------------------------  -->
<?php if ( defined( 'CONCEPT_TITLE' ) && CONCEPT_TITLE !== "") : ?>
<section class="catch p-r z-100">

  <div class="catch-inner ptb-150-tpc ptb-80-sp w-m">

    <h2 class="fs-28 jp-accent l-15 fw-n"><?php echo CONCEPT_TITLE ;?></h2>
    <?php if ( defined( 'CONCEPT_TEXT' ) && CONCEPT_TEXT !== "") : ?>
    <p class="mt-35 l-15-pc l-18-sp"><?php echo CONCEPT_TEXT ;?></p>
    <?php else : ?>
    <?php endif; ?>

  </div>

</section>
<?php endif; ?>

<!--  -----------------------------------------
  APPEAL
------------------------------------------  -->
<?php
$appeals = [
    ['title' => 'APPEAL1_TITLE', 'text' => 'APPEAL1_TEXT', 'img' => './img/appeal1_img.jpg'],
    ['title' => 'APPEAL2_TITLE', 'text' => 'APPEAL2_TEXT', 'img' => './img/appeal2_img.jpg'],
    ['title' => 'APPEAL3_TITLE', 'text' => 'APPEAL3_TEXT', 'img' => './img/appeal3_img.jpg']
];

$showAppealsSection = false;
foreach ($appeals as $appeal) {
    if ((defined($appeal['title']) && constant($appeal['title']) !== "") || 
        (defined($appeal['text']) && constant($appeal['text']) !== "")) {
        $showAppealsSection = true;
        break;
    }
}

if ($showAppealsSection): ?>
<section class="appeal bgc-fff p-r z-100">
  <div class="appeal-inner pt-40-tpc pb-60-sp pb-100-tpc pt-30-pc pb-30-pc">
    <ul class="approach-item-list prl-l-tpc prl-0-pc">
    <?php foreach ($appeals as $appeal): 
        if ((defined($appeal['title']) && constant($appeal['title']) !== "") || 
            (defined($appeal['text']) && constant($appeal['text']) !== "")): ?>
      <li class="approach-item f-container-pc a-c-pc pt-60-sp pt-80-tpc pt-0-pc">
        <div class="text f-item mrl-10vw-sp mrl-0-tpc prl-80-pc ptb-30-pc animation move-left">
          <?php if (defined($appeal['title']) && constant($appeal['title']) !== ""): ?>
          <h2 class="fs-28 jp-accent fw-n mb-40 l-12"><?php echo constant($appeal['title']); ?></h2>
          <?php endif; ?>
          <p class=" l-20-pc l-18-sp"><?php echo constant($appeal['text']); ?></p>
        </div>
        <div class="img w-50per-pc fs mt-40-sp mt-30-pc mb-30-pc animation mask-bg">
        <?php
        if (file_exists($appeal['img'])) {
          echo '<img class="target-cts img-silver" src="' . $appeal['img'] . '" alt="' . constant($appeal['title']) . '">' . "\n";
        }
        ?>
        </div>
      </li>
    <?php endif; endforeach; ?>
    </ul>
  </div>
</section>
<?php endif; ?>


<!--  -----------------------------------------
  RECRUITMENT TYPE
------------------------------------------  -->
<?php
// 配列は、config内で記述

$showRecruitmentSection = false;
foreach ($recruitments as $recruitment) {
    if ((defined($recruitment['desc']) && constant($recruitment['desc']) !== "") || 
        (defined($recruitment['catchcopy']) && constant($recruitment['catchcopy']) !== "") || 
        (defined($recruitment['min']) && constant($recruitment['min']) !== "") || 
        (defined($recruitment['max']) && constant($recruitment['max']) !== "")) {
        $showRecruitmentSection = true;
        break;
    }
}
if ($showRecruitmentSection): ?>

<section class="recruitment-type p-r z-100">
  
  <div class="recruitment-type-inner w-l-pc pt-xs pb-s of-hidden">

    <div class="t-c pb-50">
      <h2 class="fs-36 en fc-base l-15">Recruitment Type</h2>
      <p class="fw-b mt-10-pc mt-5-sp">募集職種</p>
    </div>

    <div class="recruitment-type-box pl-s-sp">
      <div class="of-x-scroll-sp">

        <ul class="recruitment-type-list g-container-3-pc f-container-sp g-20">

<?php foreach ($recruitments as $recruitment): 
  if ((defined($recruitment['desc']) && constant($recruitment['desc']) !== "") || 
      (defined($recruitment['catchcopy']) && constant($recruitment['catchcopy']) !== "") || 
      (defined($recruitment['min']) && constant($recruitment['min']) !== "") || 
      (defined($recruitment['max']) && constant($recruitment['max']) !== "")): ?>
<?php 
  $min = (float) constant($recruitment['min']);
  $max = (float) constant($recruitment['max']);
  $salary = format_salary($min, $max);
?>
          <li id="<?php echo constant($recruitment['value']); ?>" class="recruitment-type-item bgc-fff br-10 of-hidden fs">
            <div class="item-upper ptb-25 prl-20 bgc-base3 bs-b-4 bc-base2">
              <h3 class="fs-20 l-15"><?php echo constant($recruitment['catchcopy']); ?></h3>
              <p class="fc-base mt-5 fw-b"><?php echo constant($recruitment['desc']); ?></p>
            </div>
            <div class="item-lower p-20">
              <div class="g-container-1 g-5 l-15">
                <dl class="f-container">
                  <dt class="f-container w-90 nw a-c j-c fs ptb-10 bgc-base1 fc-fff">雇用形態</dt>
                  <dd class="f-item ptb-10 prl-15"><?php echo constant($recruitment['type']); ?></dd>
                </dl>
                <dl class="f-container">
                  <dt class="f-container w-90 nw a-c j-c fs ptb-10 bgc-base1 fc-fff">給与</dt>
                  <dd class="f-item ptb-10 prl-15">
                    <?php 
                      if (constant($recruitment['time']) === 'FULL_TIME'){
                        echo '月給 ';
                      }else{
                        echo '時給 ';
                      }
                      echo $salary;
                    ;?>
                  </dd>
                </dl>
              </div>
              <div class="highlight-btn mt-20">
                <a href="<?php echo constant($recruitment['value']); ?>.php" class="fc-fff h-50 bgc-base br-10 f-container j-c a-c bs-2 bc-base scale-105">詳しく見る</a>
              </div>
            </div>
          </li>
<?php endif; endforeach; ?>
        </ul>

      </div>
    </div>

  </div>

</section>
<?php endif; ?>


<!--  -----------------------------------------
  CURRICULUM
------------------------------------------  -->
<?php
// 配列は、config内で記述
function parseCurriculums($str) {
    $curriculums = [];
    if (empty(trim($str))) {
        return $curriculums; // 入力が空の場合、空の配列を返す
    }

    // カリキュラムの部分を分割
    $items = explode('【', $str);

    foreach ($items as $index => $item) {
        if (empty($item)) {
            continue;
        }

        // タイトルのないコンテンツを処理
        if ($index === 0 && strpos($item, '】') === false) {
            $curriculums[] = [
                "title" => '',
                "sections" => parseSections($item),
                "parenthesis_content" => extractParenthesisContent($item)
            ];
            continue;
        }

        $parts = explode('】', $item);
        $title = $parts[0] ?? '';
        $remaining = $parts[1] ?? '';

        // 先頭と末尾の <br /> を1つずつ削除
        $title = removeBrTags($title);
        $remaining = removeBrTags($remaining);

        $curriculums[] = [
            "title" => $title,
            "sections" => parseSections($remaining),
            "parenthesis_content" => extractParenthesisContent($remaining)
        ];
    }

    return $curriculums;
}

function parseSections($content) {
    $sections = [];
    $content_items = explode('＜', $content);
    foreach ($content_items as $content_item) {
        if (empty($content_item)) {
            continue;
        }

        $section_parts = explode('＞', $content_item);
        if (count($section_parts) == 2) {
            $month = $section_parts[0];
            $section_content = $section_parts[1];
            // 先頭と末尾の <br /> を1つずつ削除
            $month = removeBrTags($month);
            $section_content = removeBrTags($section_content);
            $sections[] = [
                "month" => $month,
                "content" => trim($section_content)
            ];
        } else {
            $sections[] = [
                "month" => '',
                "content" => trim(removeBrTags($content_item))
            ];
        }
    }

    return $sections;
}

function removeBrTags($str) {
    $str = preg_replace('/^(<br\s*\/?>)+/', '', $str); // 先頭の <br /> を削除
    $str = preg_replace('/(<br\s*\/?>)+$/', '', $str); // 末尾の <br /> を削除
    return $str;
}

function extractParenthesisContent($content) {
    preg_match('/（.*?）/', $content, $matches);
    return $matches[0] ?? '';
}

function formatCurriculum($yearTitle, $curriculums) {
    if (empty($curriculums)) {
        return ''; // カリキュラムが空の場合は空の文字列を返す
    }

    $html = '<li class="curriculum-item fs f-item bs-1 bc-eee">';
    $html .= '<h3 class="bgc-base fc-fff t-c ptb-10 fs-20">' . htmlspecialchars($yearTitle, ENT_QUOTES, 'UTF-8') . '</h3>';

    foreach ($curriculums as $curriculum) {
        if (!empty($curriculum['title'])) {
            $html .= '<h4 class="bgc-eee t-c ptb-5 mrl-10 mt-10">' . htmlspecialchars($curriculum['title'], ENT_QUOTES, 'UTF-8') . '</h4>';
        }
        $html .= '<div class="g-container-1 g-10 ptb-10 prl-10 fs-12">';
        
        foreach ($curriculum['sections'] as $section) {
            $content = trim($section['content']); // コンテンツの前後の空白を削除
            preg_match('/（.*?）/', $content, $matches);
            $content = preg_replace('/（.*?）/', '', $content);
            $content = preg_replace('/(<br\s*\/?>)+$/', '', $content);

            if (!empty($content)) { // 空のコンテンツをスキップ
                if (!empty($section['month'])) {
                    $html .= '<dl class="f-container">
                                <dt class="f-container w-60 a-c j-c fs p-10 bgc-base1 fc-fff">' . htmlspecialchars($section['month'], ENT_QUOTES, 'UTF-8') . '</dt>
                                <dd class="f-item ptb-10 prl-15">' . $content . '</dd>
                              </dl>';
                } else {
                    $html .= '<p class="f-item ptb-10 prl-15">' . $content . '</p>';
                }
            }
        }

        if (!empty($curriculum['parenthesis_content'])) {
            $html .= '<p class="t-r fs-14-tpc fs-13-sp fw-b">' . htmlspecialchars(preg_replace('/（(.*?)）/', '$1', $matches[0]), ENT_QUOTES, 'UTF-8') . '</p>';
        }

        $html .= '</div>';
    }

    $html .= '</li>';
    return $html;
}
?>

<?php
// 各年のコンテンツを生成
$curriculum_html = '';
foreach ($curriculum_data as $year) {
    $parsed_curriculums = parseCurriculums($year['contents']);
    $curriculum_html .= formatCurriculum($year['title'], $parsed_curriculums);
}

$has_curriculum_content = !empty(trim($curriculum_html));
$has_curriculum_text = defined('CURRICULUM_TEXT') && !empty(trim(CURRICULUM_TEXT));
?>

<?php if ($has_curriculum_text || $has_curriculum_content) : ?>
<section id="link-curriculum" class="curriculum bgc-fff pt-l p-r z-100">
    <div class="t-c pb-50">
        <h2 class="fs-36 en fc-base l-15">Curriculum</h2>
        <p class="fw-b mt-10-pc mt-5-sp">教育カリキュラム</p>
    </div>

    <div class="w-l-tpc w-m-pc">
        <?php if ($has_curriculum_text) : ?>
            <p class="bgc-base2 p-30 fs-16 l-15 fw-b mrl-s-sp mrl-0-tpc animation op"><?php echo CURRICULUM_TEXT; ?></p>
        <?php endif; ?>
        <?php if ($has_curriculum_content) : ?>
        <div class="curriculum-box pl-s-sp pl-0-tpc animation mt-30 op">
            <div class="of-x-scroll-sp of-x-hidden-tpc">
                <ul class="f-container l-15">
                    <?php echo $curriculum_html; ?>
                </ul>
            </div>
        </div>
        <?php endif; ?>

        <?php
          if (defined('CURRICULUM_HOW_TO_POST') && CURRICULUM_HOW_TO_POST === 'image' && file_exists('./img/curriculum_image.jpg')) :
        ?>
        <div class="curriculum-box pl-s-sp pl-0-tpc animation mt-30 op">
            <div class="of-x-scroll">
              <div class="w-800-sp w-1000-tpc w-100per-pc">
                <img class="" src="./img/curriculum_image.jpg" alt="">
              </div>
            </div>
        </div>
        <?php endif; ?>

    </div>
</section>
<?php endif; ?>

<!--  -----------------------------------------
  SHOP
------------------------------------------  -->
<section id="link-company" class="shop bgc-fff pt-l p-r z-100">

  <div class="t-c pb-50 ">
    <h2 class="fs-36 en fc-base l-15">Salon＆Company</h2>
    <p class="fw-b mt-10-pc mt-5-sp">サロン・会社概要</p>
  </div>

<?php
$slides = [
    ['title' => 'DATA_NAME' .'のイメージ画像1枚目', 'img' => './img/slide_image1.jpg'],
    ['title' => 'DATA_NAME' .'のイメージ画像2枚目', 'img' => './img/slide_image2.jpg'],
    ['title' => 'DATA_NAME' .'のイメージ画像3枚目', 'img' => './img/slide_image3.jpg'],
    ['title' => 'DATA_NAME' .'のイメージ画像4枚目', 'img' => './img/slide_image4.jpg'],
    ['title' => 'DATA_NAME' .'のイメージ画像5枚目', 'img' => './img/slide_image5.jpg'],
];

$validSlides = array_filter($slides, function($slide) {
    return file_exists($slide['img']);
});

$validSlideCount = count($validSlides);

if ($validSlideCount > 0):
?>
<div class="ptb-50-pc ptb-20-sp of-hidden">
    <div class="shop-slide swiper">
      <ul class="swiper-wrapper">
        <?php 
        if ($validSlideCount == 1) {
            for ($i = 0; $i < 3; $i++) {
                $slide = current($validSlides);
                echo '<li class="swiper-slide prl-30-pc prl-15-sp"><img class="img-silver" src="' . $slide['img'] . '" alt="' . $slide['title'] . '"></li>';
            }
        } elseif ($validSlideCount == 2) {
            $slide1 = current($validSlides);
            $slide2 = next($validSlides);
            for ($i = 0; $i < 3; $i++) {
                echo '<li class="swiper-slide prl-30-pc prl-15-sp"><img class="img-silver" src="' . $slide1['img'] . '" alt="' . $slide1['title'] . '"></li>';
                echo '<li class="swiper-slide prl-30-pc prl-15-sp"><img class="img-silver" src="' . $slide2['img'] . '" alt="' . $slide2['title'] . '"></li>';
            }
        } else {
            foreach ($validSlides as $slide) {
                echo '<li class="swiper-slide prl-30-pc prl-15-sp"><img class="img-silver" src="' . $slide['img'] . '" alt="' . $slide['title'] . '"></li>';
            }
        }
        ?>
      </ul>
      <div class="swiper-button-next fs-40"></div>
      <div class="swiper-button-prev fs-40"></div>
    </div>
</div>
<?php endif; ?>


<?php
$shops = [
    ['title' => 'SHOP1_NAME', 'address' => 'SHOP1_ADDRESS', 'tel' => 'SHOP1_TEL', 'url' => 'SHOP1_URL', 'img' => './img/shop1_image.jpg'],
    ['title' => 'SHOP2_NAME', 'address' => 'SHOP2_ADDRESS', 'tel' => 'SHOP2_TEL', 'url' => 'SHOP2_URL', 'img' => './img/shop2_image.jpg'],
    ['title' => 'SHOP3_NAME', 'address' => 'SHOP3_ADDRESS', 'tel' => 'SHOP3_TEL', 'url' => 'SHOP3_URL', 'img' => './img/shop3_image.jpg'],
    ['title' => 'SHOP4_NAME', 'address' => 'SHOP4_ADDRESS', 'tel' => 'SHOP4_TEL', 'url' => 'SHOP4_URL', 'img' => './img/shop4_image.jpg'],
    ['title' => 'SHOP5_NAME', 'address' => 'SHOP5_ADDRESS', 'tel' => 'SHOP5_TEL', 'url' => 'SHOP5_URL', 'img' => './img/shop5_image.jpg'],
    ['title' => 'SHOP6_NAME', 'address' => 'SHOP6_ADDRESS', 'tel' => 'SHOP6_TEL', 'url' => 'SHOP6_URL', 'img' => './img/shop6_image.jpg'],
    ['title' => 'SHOP7_NAME', 'address' => 'SHOP7_ADDRESS', 'tel' => 'SHOP7_TEL', 'url' => 'SHOP7_URL', 'img' => './img/shop7_image.jpg'],
    ['title' => 'SHOP8_NAME', 'address' => 'SHOP8_ADDRESS', 'tel' => 'SHOP8_TEL', 'url' => 'SHOP8_URL', 'img' => './img/shop8_image.jpg'],
    ['title' => 'SHOP9_NAME', 'address' => 'SHOP9_ADDRESS', 'tel' => 'SHOP9_TEL', 'url' => 'SHOP9_URL', 'img' => './img/shop9_image.jpg'],
    ['title' => 'SHOP10_NAME', 'address' => 'SHOP10_ADDRESS', 'tel' => 'SHOP10_TEL', 'url' => 'SHOP10_URL', 'img' => './img/shop10_image.jpg'],
];

$showShopsSection = false;
$definedShopsCount = 0;

foreach ($shops as $shop) {
    if (defined($shop['title']) && constant($shop['title']) !== "") {
        $definedShopsCount++;
        if ($definedShopsCount >= 2) {
            $showShopsSection = true;
            break;
        }
    }
}

if ($showShopsSection): ?>
  <div class="shop-list mt-20">
    <ul class="bgc-base3 g-container-2-tpc">
      <?php foreach ($shops as $shop): 
        if ((defined($shop['title']) && constant($shop['title']) !== "")): ?>
      <li class="shop-item prl-s ptb-40-sp ptb-40-pc">
        <div class="shop-item-inner f-container">
          <div class="w-100-sp h-100-sp w-150-pc h-150-pc fs animation mask-bg">
            <?php
            if (file_exists($shop['img'])) {
              echo '<img class="target-cts img-square" src="' . $shop['img'] . '" alt="' . constant($shop['title']) . 'のイメージ画像">' . "\n";
            }
            ?>
          </div>
          <div class="pl-20-sp pl-30-pc animation move-left">
            <h3 class="fs-20 l-15"><?php echo constant($shop['title']); ?></h3>
            <?php if ((defined($shop['address']) && constant($shop['address']) !== "") || (defined($shop['tel']) && constant($shop['tel']) !== "")) : ?>
            <address class="mt-10-sp mt-15-pc">
              <?php if (defined($shop['address']) && constant($shop['address']) !== ""): ?>
              <p class="l-15"><?php echo constant($shop['address']); ?></p>
              <?php endif; ?>
              <?php if (defined($shop['tel']) && constant($shop['tel']) !== ""): ?>
              <div class="tel f-container a-c fs-20 fw-b mt-8-sp mt-8-pc">
                <p>TEL&nbsp;&nbsp;</p>
                <div class="tel">
                  <p class="pc"><?php echo constant($shop['tel']); ?></p>
                  <a class="sp" href="tel:<?php echo constant($shop['tel']); ?>"><?php echo constant($shop['tel']); ?></a>
                </div>
              </div>
              <?php endif; ?>
            </address>
            <?php endif; ?>
            <?php if (defined($shop['url']) && constant($shop['url']) !== ""): ?>
            <a class="ptb-10 prl-20-sp prl-20-pc bc-base1 bs-1 br-5 fc-base1 mt-15 fw-b f-container-sp fi-container-tpc a-c j-c zoom-item scale-105" href="<?php echo constant($shop['url']); ?>" target="_blank">
              <span class="mr-8"></span>ホームページはこちら
            </a>
            <?php endif; ?>
          </div>
        </div>
      </li>
      <?php endif; endforeach; ?>
    </ul>
  </div>
<?php else :?>
  <?php foreach ($shops as $shop): 
        if (defined($shop['title']) && constant($shop['title']) !== ""): ?>
    <div class="w-l f-container-tpc f-row-reverse-tpc a-c ptb-xs">
      <div class="w-100per-pc pl-40-tpc animation move-left">
        <h2 class="bs-b-1 bc-base1 mb-30 pb-20 fs-24"><?php echo constant($shop['title']); ?></h2>
        <?php if ((defined('DATA_ADDRESS_REGION') && DATA_ADDRESS_REGION !== "") && (defined('DATA_ADDRESS_LOCALITY') && DATA_ADDRESS_LOCALITY !== "") && (defined('DATA_STREET_ADDRESS') && DATA_STREET_ADDRESS !== "")): ?>
        <p><?php echo DATA_ADDRESS_REGION; ?><?php echo DATA_ADDRESS_LOCALITY; ?><?php echo DATA_STREET_ADDRESS; ?></p>
        <?php endif; ?>
        <?php if (defined($shop['tel']) && constant($shop['tel']) !== ""): ?>
        <div class="tel mt-20-sp mt-30-pc fs-24-sp fs-30-pc fw-b">
          <p class="pc"><?php echo constant($shop['tel']); ?></p>
          <a class="sp" href="tel:<?php echo constant($shop['tel']); ?>"><?php echo constant($shop['tel']); ?></a>
        </div>
        <?php endif; ?>
        <?php if (defined('DATA_JOB_MESSAGE') && DATA_JOB_MESSAGE !== ""): ?>
            <p class="mt-20-sp mt-30-pc bgc-eee p-30">
                <?php echo DATA_JOB_MESSAGE; ?>
            </p>
        <?php endif; ?>
        <?php if (defined($shop['url']) && constant($shop['url']) !== ""): ?>
        <a class="ptb-15 prl-20-sp prl-20-pc bc-base1 bs-1 br-5 fc-base1 mt-15 fw-b f-container-sp fi-container-tpc a-c j-c zoom-item scale-105 w-100per" href="<?php echo constant($shop['url']); ?>" target="_blank">
          <span class="mr-8"></span>ホームページはこちら
        </a>
        <?php endif; ?>
      </div>
      <div class="img w-50per-tpc fs animation mask-bg mt-30-sp">
        <img class="target-cts img-square" src="<?php echo $shop['img']; ?>" alt="<?php echo constant($shop['title']); ?>のイメージ画像">
      </div>
    </div>
    <?php endif; endforeach; ?>
<?php endif; ?>

  <div class="company bgc-base prl-s ptb-50 fc-fff animation op">
  
    <div class="company-data f-container-tpc l-15">
      <ul class="w-60per-pc w-100per pr-40 g-container-1 g-r-30">
        <li class="f-container">
          <h3 class="w-130-pc w-90-tpc w-100-sp fs nw">社名</h3>
          <?php if (defined( 'DATA_COMPANY' ) && DATA_COMPANY !== ""): ?>
            <p class="l-15"><?php echo DATA_COMPANY ; ?></p>
          <?php else : ?>
          <p class="l-15"><?php echo DATA_NAME ; ?></p>
          <?php endif; ?>
        </li>
        <li class="f-container">
          <h3 class="w-130-pc w-90-tpc w-100-sp fs nw">所在地</h3>
          <p class="w-100per">〒<?php echo DATA_POSTAL_CODE ;?><br>
          <?php echo DATA_ADDRESS_REGION ;?><?php echo DATA_ADDRESS_LOCALITY ;?><?php echo DATA_STREET_ADDRESS ;?></p>
        </li>
        <?php if (defined( 'DATA_TEL' ) && DATA_TEL !== ""): ?>
        <li class="f-container">
          <h3 class="w-130-pc w-90-tpc w-100-sp fs nw nw">代表番号</h3>
          <div class="nw">
            <p class="pc"><?php echo DATA_TEL ;?></p>
            <a class="sp" href="tel:<?php echo DATA_TEL ;?>"><?php echo DATA_TEL ;?></a>
          </div>
        </li>
        <?php endif; ?>
      </ul>
      <ul class="fs g-container-1 g-r-30 mt-30 mt-0-tpc pr-80-tpc">
        <li class="f-container">
          <h3 class="w-130-pc w-90-tpc w-100-sp fs nw">代表名</h3>
          <p class="w-100per nw"><?php echo DATA_REPRESENTATIVE_NAME ;?></p>
        </li>
        <?php if (defined( 'DATA_NUMBER_OF_STORES' ) && DATA_NUMBER_OF_STORES !== ""): ?>
        <li class="f-container">
          <h3 class="w-130-pc w-90-tpc w-100-sp fs nw">店舗数</h3>
          <p class="w-100per nw"><?php echo DATA_NUMBER_OF_STORES ;?>店舗</p>
        </li>
        <?php endif; ?>
        <?php if (defined( 'DATA_TOTAL_STAFF' ) && DATA_TOTAL_STAFF !== ""): ?>
        <li class="f-container">
          <h3 class="w-130-pc w-90-tpc w-100-sp fs nw">スタッフ数</h3>
          <p class="w-100per nw"><?php echo DATA_TOTAL_STAFF ;?>名</p>
        </li>
        <?php endif; ?>
      </ul>
    </div>
    <?php if (defined( 'DATA_ACHIEVEMENTS' ) && DATA_ACHIEVEMENTS !== ""): ?>
    <div class="company-alma-mater bs-1 bc-fff prl-20 ptb-25 mt-40">
      <h3>採用実績（出身校）</h3>
      <p class="mt-20 l-15"><?php echo DATA_ACHIEVEMENTS ;?></p>
    </div>
    <?php endif; ?>

  </div>

  <?php if(defined('DATA_PDF_TEXT') && DATA_PDF_TEXT !== "") :?>
  <div class="pdf-download w-m pt-30 animation op">
    <p class="t-c"><?php echo DATA_PDF_TEXT ;?>を以下よりダウンロードできます</p>
    <div class="highlight-btn w-max300-tpc mt-20 mrl-auto pb-10">
      <a class="f-container a-c j-c g-10 bgc-base fc-fff h-50 br-10 bs-2 bc-base scale-115" href="./img/company.pdf" target="_blank">
        <span><?php echo DATA_PDF_TEXT ;?></span>
        <div class="icon">
          <span class="material-symbols-outlined fs-20-sp fs-20-pc">download</span>
        </div>
      </a>
    </div>
  </div>
  <?php endif ;?>
  
</section>


<!--  -----------------------------------------
  INTERVIEW
------------------------------------------  -->
<?php
$interviews = [
    ['name' => 'STAFF1_NAME', 'type' => 'STAFF1_TYPE', 'message' => 'STAFF1_MESSAGE', 'qa1-question' => 'STAFF1_QA1_QUESTION', 'qa1-answer' => 'STAFF1_QA1_ANSWER', 'qa2-question' => 'STAFF1_QA2_QUESTION', 'qa2-answer' => 'STAFF1_QA2_ANSWER', 'qa3-question' => 'STAFF1_QA3_QUESTION', 'qa3-answer' => 'STAFF1_QA3_ANSWER', 'img' => './img/staff1_image.jpg'],
    ['name' => 'STAFF2_NAME', 'type' => 'STAFF2_TYPE', 'message' => 'STAFF2_MESSAGE', 'qa1-question' => 'STAFF2_QA1_QUESTION', 'qa1-answer' => 'STAFF2_QA1_ANSWER', 'qa2-question' => 'STAFF2_QA2_QUESTION', 'qa2-answer' => 'STAFF2_QA2_ANSWER', 'qa3-question' => 'STAFF2_QA3_QUESTION', 'qa3-answer' => 'STAFF2_QA3_ANSWER', 'img' => './img/staff2_image.jpg'],
    ['name' => 'STAFF3_NAME', 'type' => 'STAFF3_TYPE', 'message' => 'STAFF3_MESSAGE', 'qa1-question' => 'STAFF3_QA1_QUESTION', 'qa1-answer' => 'STAFF3_QA1_ANSWER', 'qa2-question' => 'STAFF3_QA2_QUESTION', 'qa2-answer' => 'STAFF3_QA2_ANSWER', 'qa3-question' => 'STAFF3_QA3_QUESTION', 'qa3-answer' => 'STAFF3_QA3_ANSWER', 'img' => './img/staff3_image.jpg'],
];


$showInterviewSection = false;
foreach ($interviews as $interview) {
    if ((defined($interview['name']) && constant($interview['name']) !== "") || (defined("REPRESENTATIVE_NAME") && REPRESENTATIVE_NAME !== "")) {
        $showInterviewSection = true;
        break;
    }
}
if ($showInterviewSection): ?>
<section class="interview bgc-fff p-r z-100">

  <div class="t-c pb-50 pt-l">
    <h2 class="fs-36 en fc-base l-15">Interview</h2>
    <p class="fw-b mt-10-pc mt-5-sp">インタビュー</p>
  </div>
  <?php if (defined($interview['name']) && constant($interview['name']) !== ""): ?>
  <div class="staff w-m g-container-1 g-80">
    <?php foreach ($interviews as $interview): 
      if (defined($interview['name']) && constant($interview['name']) !== "") :?>
    <div class="staff-item f-container-tpc">
      <div class="staff-img fs animation mask-bg">
        <?php
          if (file_exists($interview['img'])) {
            echo '<img class="target-cts img-square" src="' . $interview['img'] . '" alt="' . constant($interview['name']) . 'のイメージ画像">' . "\n";
          }
        ?>
      </div>
      <div class="pl-40-tpc mt-30-sp mt-0-tpc animation move-left w-100per">
        <div class="bs-b-1 bc-base1 mb-30 pb-20">
          <?php if (defined($interview['type']) && constant($interview['type']) !== ""): ?>
          <p class="fs-12 pb-10 fc-base1 fw-b"><?php echo constant($interview['type']); ?></p>
          <?php endif; ?>
          <h3 class="fs-20-sp fs-24-pc"><?php echo constant($interview['name']); ?></h3>
        </div>
        <?php if (defined($interview['message']) && constant($interview['message']) !== ""): ?>
        <p class="pb-30 l-20"><?php echo constant($interview['message']); ?></p>
        <?php endif; ?>
        <?php if ((defined($interview['qa1-question']) && constant($interview['qa1-question']) !== "") || (defined($interview['qa2-question']) && constant($interview['qa2-question']) !== "") || (defined($interview['qa3-question']) && constant($interview['qa3-question']) !== "")): ?>
        <ul class="faq-list g-container-1 g-20 l-15">
          <?php if (defined($interview['qa1-question']) && constant($interview['qa1-question']) !== ""): ?>
          <li class="bgc-base3 border-item">
            <h4 class="accordion-trigger f-container j-sb a-c pr-20">
              <span class="p-20"><?php echo constant($interview['qa1-question']); ?></span>
              <span class="icon w-40 h-40 br-circle bgc-base1 db p-r"></span>
            </h4>
            <div class="accordion-target fc-fff prl-20 pb-20">
              <p class="bgc-base1 p-20 l-15"><?php echo constant($interview['qa1-answer']); ?></p>
            </div>
          </li>
          <?php endif; ?>
          <?php if (defined($interview['qa2-question']) && constant($interview['qa2-question']) !== ""): ?>
          <li class="bgc-base3 border-item">
            <h4 class="accordion-trigger f-container j-sb a-c pr-20">
              <span class="p-20"><?php echo constant($interview['qa2-question']); ?></span>
              <span class="icon w-40 h-40 br-circle bgc-base1 db p-r"></span>
            </h4>
            <div class="accordion-target fc-fff prl-20 pb-20">
              <p class="bgc-base1 p-20 l-15"><?php echo constant($interview['qa2-answer']); ?></p>
            </div>
          </li>
          <?php endif; ?>
          <?php if (defined($interview['qa3-question']) && constant($interview['qa3-question']) !== ""): ?>
          <li class="bgc-base3 border-item">
            <h4 class="accordion-trigger f-container j-sb a-c pr-20">
              <span class="p-20"><?php echo constant($interview['qa3-question']); ?></span>
              <span class="icon w-40 h-40 br-circle bgc-base1 db p-r"></span>
            </h4>
            <div class="accordion-target fc-fff prl-20 pb-20">
              <p class="bgc-base1 p-20 l-15"><?php echo constant($interview['qa3-answer']); ?></p>
            </div>
          </li>
          <?php endif; ?>
        </ul>
        <?php endif; ?>
      </div>
    </div>
    <?php endif; endforeach; ?>
  </div>
  <?php endif; ?>

  <?php if (defined("REPRESENTATIVE_NAME") && REPRESENTATIVE_NAME !== ""): ?>
  <div class="manager pt-s pl-m-tpc f-container-tpc f-row-reverse-tpc a-c-pc">
    <div class="manager-img w-50per-tpc fs animation mask-bg">
      <?php
        if (file_exists('./img/representative_image.jpg')) {
          echo '<img class="target-cts img-square" src="./img/representative_image.jpg" alt="';
          if (defined('DATA_COMPANY') && DATA_COMPANY !== "") {
            echo DATA_COMPANY . ' ';
          } else {
            echo DATA_NAME . ' ';
          }
          echo REPRESENTATIVE_POSITION . ' ' . REPRESENTATIVE_NAME;
          if (defined('REPRESENTATIVE_RUBY') && REPRESENTATIVE_RUBY !== "") {
            echo '(' . REPRESENTATIVE_RUBY . ')';
          }
          echo 'のイメージ画像">' . "\n";
        }
      ?>
    </div>
    <div class="w-100per prl-s-sp mt-40-sp mt-0-tpc pr-40-tpc pr-80-pc animation move-left">
      <div class="bs-b-1 bc-base1 pb-20">
        <?php if (defined("REPRESENTATIVE_POSITION") && REPRESENTATIVE_POSITION !== ""): ?>
        <p class="fs-12 pb-10 fc-base1 fw-b"><?php echo REPRESENTATIVE_POSITION; ?></p>
        <?php endif; ?>
        <h3 class="fs-24"><?php echo REPRESENTATIVE_NAME; ?></h3>
      </div>
      <?php if (defined("REPRESENTATIVE_RUBY") && REPRESENTATIVE_RUBY !== ""): ?>
      <p class="pt-10 fc-base1 t-r"><?php echo REPRESENTATIVE_RUBY; ?></p>
      <?php endif; ?>
      <?php if (defined("REPRESENTATIVE_TEXT") && REPRESENTATIVE_TEXT !== ""): ?>
      <p class="pt-20 l-20"><?php echo REPRESENTATIVE_TEXT; ?></p>
      <?php endif; ?>
    </div>
  </div>
<?php endif; ?>

</section>
<?php endif; ?>


<!--  -----------------------------------------
  EVENT
------------------------------------------  -->
<?php
// 配列、セクションの分岐は、config内で記述

if ($showEventSection): ?>
<section id="link-event" class="event bgc-fff p-r z-100">

  <div class="t-c pb-40 pt-l">
    <h2 class="fs-36 en fc-base l-15">Event</h2>
    <p class="fw-b mt-10-pc mt-5-sp">イベント</p>
  </div>
  <ul class="event-list w-l-tpc w-m-sp w-m-pc g-container-2-sp g-container-4-tpc g-20-sp g-40-pc">
    <?php foreach ($events as $event): 
      if (file_exists($event['img1'])) :?>
    <li class="event-list-item animation move-left<?php echo ' ' . $event['class'] ?>">
      <div href="#<?php echo $event['id'];?>" class="popup">
        <div class="event-item-img of-hidden border-item">
          <img class="targetImg zoom-item scale-115 img-square" src="<?php echo $event['img1'];?>" alt="<?php echo constant($event['title']) . 'イメージ画像' ?>">
        </div>
        <?php if (constant($event['title']) !== "") :?>
        <p class="mt-15-pc mt-10-sp"><?php echo constant($event['title']) ?></p>
        <?php endif; ?>
      </div>
      <div id="<?php echo $event['id'];?>" class="mfp-hide">
        <div class="w-max600-tpc mrl-auto bgc-fff">
          <ul class="g-container-2 g-20-sp g-30-tpc p-40-tpc p-25-sp">
            <li><img class="img-square" src="<?php echo $event['img1'];?>" alt="<?php echo constant($event['title']) . 'イメージ画像' ?>"></li>
            <?php if (file_exists($event['img2'])) : ?>
            <li><img class="img-square" src="<?php echo $event['img2'];?>"alt="<?php echo constant($event['title']) . 'イメージ画像' ?>"></li>
            <?php endif; ?>
            <?php if (file_exists($event['img3'])) : ?>
            <li><img class="img-square" src="<?php echo $event['img3'];?>" alt="<?php echo constant($event['title']) . 'イメージ画像' ?>"></li>
            <?php endif; ?>
            <?php if (file_exists($event['img4'])) : ?>
            <li><img class="img-square" src="<?php echo $event['img4'];?>" alt="<?php echo constant($event['title']) . 'イメージ画像' ?>"></li>
            <?php endif; ?>
          </ul>
        </div>
      </div>
    </li>
    <?php endif; endforeach; ?>
  </ul>

</section>
<?php endif; ?>


<!--  -----------------------------------------
  FLOW
------------------------------------------  -->
<?php
// 配列、セクションの分岐は、config内で記述

if ($showFlowSection): ?>
<section id="link-flow" class="flow bgc-fff pt-l p-r z-100">

  <div class="t-c pb-50">
    <h2 class="fs-36 en fc-base l-15">Flow</h2>
    <p class="fw-b mt-10-pc mt-5-sp">採用フロー</p>
  </div>

  <div class="pl-s-sp prl-m-pc">
    <div class="flow-box of-x-scroll-sp pb-10-sp">

      <ul class="flow-list f-container g-40">
        <?php foreach ($flows as $flow):
        if (defined($flow['title']) && constant($flow['title']) !== "") :?>
        <li class="f-item animation move-left<?php echo ' ' . $flow['class'] ?>">
          <h3 class="bgc-base2 fw-b fs-16 p-20 t-c p-r l-15"><?php echo constant($flow['title']) ?></h3>
          <?php if (defined($flow['text']) && constant($flow['text']) !== "") :?>
          <p class="mt-20 l-15">
            <?php echo constant($flow['text']) ?>
          </p>
          <?php endif; ?>
        </li>
        <?php endif; endforeach; ?>
      </ul>

    </div>
  </div>
  <?php if (defined('FLOW_SUPPLEMENT') && FLOW_SUPPLEMENT !== "") :?>
  <div class="w-m-pc w-l-sp pt-30 animation op">
    <p class="bgc-eee l-15 p-30">
      <?php echo FLOW_SUPPLEMENT ?>
    </p>
  </div>
  <?php endif; ?>
</section>
<?php endif; ?>

<?php if ($showFlowSection || $showEventSection || $showInterviewSection) : ?>
<div class="section-space pt-l bgc-fff p-r z-100">
  
</div>
<?php endif; ?>

<!--  -----------------------------------------
  ENTRY
------------------------------------------  -->
<?php
  include($_SERVER['DOCUMENT_ROOT'].'/entry_section.php');
  echo "\n";
?>


</main>


<!--  -----------------------------------------
  FOOTER
------------------------------------------  -->
<?php
  include($_SERVER['DOCUMENT_ROOT'].'/footer.php');
  echo "\n";
?>
</body>
</html>