<?php
// 設定コード
$googleFont = array('Courgette','Noto+Sans+JP:wght@400;500');
$file = basename($_SERVER["PHP_SELF"]);
$fileName = pathinfo($file, PATHINFO_FILENAME);
define( "PAGE_PASS" , $fileName);
define( "DOMAIN" , (empty($_SERVER['HTTPS']) ? 'http://' : 'https://') . $_SERVER['HTTP_HOST']) ;
define( "PAGE_URL" , (empty($_SERVER['HTTPS']) ? 'http://' : 'https://') . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']) ;

$recruitments = [
    ['value' => 'JOB1_TYPE_VALUE','type' => 'JOB1_TYPE', 'desc' => 'JOB1_JOB_DESCRIPTION', 'catchcopy' => 'JOB1_CATCHCOPY', 'min' => 'JOB1_MINIMUM_WAGE', 'max' => 'JOB1_MAXIMUM_WAGE', 'time' => 'JOB1_WORKING_TIME'],
    ['value' => 'JOB2_TYPE_VALUE','type' => 'JOB2_TYPE', 'desc' => 'JOB2_JOB_DESCRIPTION', 'catchcopy' => 'JOB2_CATCHCOPY', 'min' => 'JOB2_MINIMUM_WAGE', 'max' => 'JOB2_MAXIMUM_WAGE', 'time' => 'JOB2_WORKING_TIME'],
    ['value' => 'JOB3_TYPE_VALUE', 'type' => 'JOB3_TYPE', 'desc' => 'JOB3_JOB_DESCRIPTION', 'catchcopy' => 'JOB3_CATCHCOPY', 'min' => 'JOB3_MINIMUM_WAGE', 'max' => 'JOB3_MAXIMUM_WAGE', 'time' => 'JOB3_WORKING_TIME'],
    ['value' => 'JOB4_TYPE_VALUE', 'type' => 'JOB4_TYPE', 'desc' => 'JOB4_JOB_DESCRIPTION', 'catchcopy' => 'JOB4_CATCHCOPY', 'min' => 'JOB4_MINIMUM_WAGE', 'max' => 'JOB4_MAXIMUM_WAGE', 'time' => 'JOB4_WORKING_TIME'],
    ['value' => 'JOB5_TYPE_VALUE', 'type' => 'JOB5_TYPE', 'desc' => 'JOB5_JOB_DESCRIPTION', 'catchcopy' => 'JOB5_CATCHCOPY', 'min' => 'JOB5_MINIMUM_WAGE', 'max' => 'JOB5_MAXIMUM_WAGE', 'time' => 'JOB5_WORKING_TIME'],
]; 

function format_salary($min, $max) {
    $formatted_min = number_format($min);
    $formatted_max = number_format($max);

    if ($min === 0.0) {
        if ($max === 0.0) {
            return "■■■円"; // 両方が0の場合
        } else {
            return "{$formatted_max}円"; // minが0の場合
        }
    } elseif ($max === 0.0) {
        return "{$formatted_min}円"; // maxが0の場合
    } elseif ($min == $max) {
        return "{$formatted_min}円"; // minとmaxが同じ場合
    } elseif ($min < $max) {
        return "{$formatted_min}円〜{$formatted_max}円"; // minがmaxより小さい場合
    } else {
        return "{$formatted_max}円〜{$formatted_min}円"; // maxがminより小さい場合
    }
}

$curriculum_data = [
    ['title' => '1年目', 'contents' => CURRICULUM_YEAR1],
    ['title' => '2年目', 'contents' => CURRICULUM_YEAR2],
    ['title' => '3年目', 'contents' => CURRICULUM_YEAR3],
];

$events = [
    ['id' => 'event1', 'title' => 'EVENT1_TITLE', 'img1' => './img/event1_image1.jpg', 'img2' => './img/event1_image2.jpg', 'img3' => './img/event1_image3.jpg', 'img4' => './img/event1_image4.jpg', 'class' => ''],
    ['id' => 'event2', 'title' => 'EVENT2_TITLE', 'img1' => './img/event2_image1.jpg', 'img2' => './img/event2_image2.jpg', 'img3' => './img/event2_image3.jpg', 'img4' => './img/event2_image4.jpg', 'class' => 'td-02'],
    ['id' => 'event3', 'title' => 'EVENT3_TITLE', 'img1' => './img/event3_image1.jpg', 'img2' => './img/event3_image2.jpg', 'img3' => './img/event3_image3.jpg', 'img4' => './img/event3_image4.jpg', 'class' => 'td-04-tpc'],
    ['id' => 'event4', 'title' => 'EVENT4_TITLE', 'img1' => './img/event4_image1.jpg', 'img2' => './img/event4_image2.jpg', 'img3' => './img/event4_image3.jpg', 'img4' => './img/event4_image4.jpg', 'class' => 'td-02-sp td-06-tpc'],
];

$showEventSection = false;
foreach ($events as $event) {
    if (file_exists($event['img1'])) {
        $showEventSection = true;
        break;
    }
}

$flows = [
    ['title' => 'FLOW_STEP1_TITLE', 'text' => 'FLOW_STEP1_TEXT', 'class' => ''],
    ['title' => 'FLOW_STEP2_TITLE', 'text' => 'FLOW_STEP2_TEXT', 'class' => 'td-02'],
    ['title' => 'FLOW_STEP3_TITLE', 'text' => 'FLOW_STEP3_TEXT', 'class' => 'td-04'],
    ['title' => 'FLOW_STEP4_TITLE', 'text' => 'FLOW_STEP4_TEXT', 'class' => 'td-06'],
    ['title' => 'FLOW_STEP5_TITLE', 'text' => 'FLOW_STEP5_TEXT', 'class' => 'td-08'],
];

$showFlowSection = false;
foreach ($flows as $flow) {
    if (defined($flow['title']) && constant($flow['title']) !== "") {
        $showFlowSection = true;
        break;
    }
}
?>