<!DOCTYPE HTML>
<html lang="ja">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="format-detection" content="telephone=no, email=no, address=no">

<?php if (defined('PAGE_DESC') && PAGE_DESC !== '') : ?>
<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo ANALYTICS; ?>"></script>
<script>
window.dataLayer = window.dataLayer || [];
function gtag(){dataLayer.push(arguments);}
gtag('js', new Date());
gtag('config', '<?php echo ANALYTICS; ?>');
</script>
<?php else: ?>
<?php endif; ?>

<?php if ( defined( 'PAGE_PASS' ) && PAGE_PASS == "index" ) : ?>
<title><?php echo DATA_SITE_TITLE ; ?></title>
<?php else : ?>
<title><?php echo PAGE_TITLE ; ?>｜<?php echo DATA_SITE_TITLE ; ?></title>
<?php endif; ?>

<?php if (defined('PAGE_DESC') && PAGE_DESC !== '') : ?>
<meta name="description" content="<?php echo PAGE_DESC; ?><?php echo DATA_JOB_MESSAGE; ?>">
<?php else : ?>
<meta name="description" content="<?php echo DATA_JOB_MESSAGE; ?>">
<?php endif; ?>

<?php if (defined('SITE_KEYWORD') && SITE_KEYWORD !== '') : ?>
<meta name="keywords" content="<?php echo SITE_KEYWORD ; ?>">
<?php else : ?>
<?php endif; ?>
<meta property="og:url" content="<?php echo PAGE_URL ; ?>">
<?php if ( defined( 'PAGE_PASS' ) && PAGE_PASS == "index" ) : ?>
  <meta property="og:title" content="<?php echo DATA_SITE_TITLE ; ?>">
<?php else : ?>
  <meta property="og:title" content="<?php echo PAGE_TITLE ; ?>｜<?php echo DATA_SITE_TITLE ; ?>">
<?php endif; ?>
<?php if (defined('PAGE_DESC') && PAGE_DESC !== '') : ?>
<meta property="og:description" content="<?php echo PAGE_DESC; ?><?php echo DATA_JOB_MESSAGE; ?>">
<?php else : ?>
<meta property="og:description" content="<?php echo DATA_JOB_MESSAGE; ?>">
<?php endif; ?>
<?php if( defined( 'PAGE_PASS' ) && PAGE_PASS == "index" ) : ?>
<meta property="og:type" content="website">
<?php else : ?>
<meta property="og:type" content="article">
<?php endif; ?>
<meta property="og:site_name" content="<?php echo DATA_SITE_TITLE ; ?>">
<meta property="og:locale" content="ja_JP">
<meta name="twitter:card" content="summary_large_image">
<?php
$ogImg = $_SERVER['DOCUMENT_ROOT']. '/img/ogImg.png';
// CSSファイルが存在するかチェックする
if (file_exists($ogImg)) {
  echo '<meta property="og:image" content="'. DOMAIN . '/img/ogImg.png">'."\n";
} else {
  $data = "[ogImg.png] not find";
  echo '<script>';
  echo 'console.log('. json_encode( $data ) .')';
  echo '</script>'."\n";
}
?>
<link rel="canonical" href="<?php echo PAGE_URL ; ?>">
<?php
$favicon = $_SERVER['DOCUMENT_ROOT']. '/img/favicon.ico';
// CSSファイルが存在するかチェックする
if (file_exists($favicon)) {
  echo '<link rel="icon" href="'. DOMAIN . '/img/favicon.ico">'."\n";
} else {
  $data = "[ogImg.png] not find";
  echo '<script>';
  echo 'console.log('. json_encode( $data ) .')';
  echo '</script>'."\n";
}
?>
<?php
$appletouchicon = $_SERVER['DOCUMENT_ROOT']. '/img/apple-touch-icon.png';
// CSSファイルが存在するかチェックする
if (file_exists($appletouchicon)) {
  echo '<link rel="apple-touch-icon" href="'. DOMAIN . '/img/apple-touch-icon.png">'."\n";
} else {
  $data = "[apple-touch-icon.png] not find";
  echo '<script>';
  echo 'console.log('. json_encode( $data ) .')';
  echo '</script>'."\n";
}
?>

<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@24,400,1,0" />

<!-- Preconnect to Google Fonts -->
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Courgette&display=swap" rel="stylesheet">
<link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@400;500&display=swap" rel="stylesheet">

<?php if (!empty($googleFont)) : ?>
<!-- Preconnect to Google Fonts -->
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<?php endif ?>
<?php if (!empty($googleFont)) : ?>
<?php foreach ($googleFont as $value) : ?>
<link href="https://fonts.googleapis.com/css2?family=<?php echo $value ; ?>&display=swap" rel="stylesheet">
<?php endforeach; ?>
<?php endif ?>
<?php if (!empty($googleFont)) : ?>
<?php endif ?>

<!-- JSON-LD structured data -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@graph": [
    {
      "@type": "Organization",
      "name": "<?php echo DATA_SITE_TITLE; ?>",
      "image": "<?php echo DOMAIN; ?>/img/ogImg.png",
      "address": {
        "@type": "PostalAddress",
        "streetAddress": "<?php echo DATA_STREET_ADDRESS; ?>",
        "addressLocality": "<?php echo DATA_ADDRESS_LOCALITY; ?>",
        "addressRegion": "<?php echo DATA_ADDRESS_REGION; ?>",
        "addressCountry": "日本",
        "postalCode": "<?php echo DATA_POSTAL_CODE; ?>"
      }
    },
    {
      "@type": "BreadcrumbList",
      "name": "パンくずリスト",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "ホーム",
          "item": "<?php echo DOMAIN; ?>"
        }
        <?php if (defined('PAGE_PASS') && PAGE_PASS != "index") : ?>,
        {
          "@type": "ListItem",
          "position": 2,
          "name": "<?php echo PAGE_TITLE; ?>",
          "item": "<?php echo PAGE_URL; ?>"
        }
        <?php endif; ?>
      ]
    }
  ]
}
</script>


<?php if (!empty($plugIn__css)) : ?>
<!-- Custom CSS --><?php endif ?>
<?php if (!empty($plugIn__css)) : ?>
<?php foreach ($plugIn__css as $value) : ?>
<link rel="stylesheet" href="./plugin/<?php echo $value ; ?>.css">
<?php endforeach; ?>
<?php endif ?>
<?php if (!empty($plugIn__css)) : ?>
<?php endif ?>

<link rel="stylesheet" href="./css/base.css">
<link rel="stylesheet" href="./css/custom.css">
<link rel="stylesheet" href="./css/common.css">
