<?php
  ini_set( 'display_errors', 1 );

  define( "DIR_NAME", basename(dirname(__FILE__)));
  include($_SERVER['DOCUMENT_ROOT'].'/inc/data.php');
  include($_SERVER['DOCUMENT_ROOT'].'/inc/config.php');

  preg_match('/(\d+)$/', $fileName, $matches);
  $suffix = isset($matches[1]) ? $matches[1] : '1'; // 数字が見つからない場合はデフォルトで1

  // 定数が存在するかどうかをチェックして、存在しない場合は空の値を設定する関数を定義
  function get_defined_or_default($constant_name, $default = '') {
      return defined($constant_name) ? constant($constant_name) : $default;
  }

  // 抽出された数字に基づいて定数を動的に定義
  define("JOB_CATCHCOPY", constant("JOB" . $suffix . "_CATCHCOPY"));
  define("JOB_TYPE", constant("JOB" . $suffix . "_TYPE"));
  define("JOB_WORKING_TIME", constant("JOB" . $suffix . "_WORKING_TIME"));
  define("JOB_MINIMUM_WAGE", constant("JOB" . $suffix . "_MINIMUM_WAGE"));
  define("JOB_MAXIMUM_WAGE", constant("JOB" . $suffix . "_MAXIMUM_WAGE"));
  define("JOB_DESCRIPTION", constant("JOB" . $suffix . "_JOB_DESCRIPTION"));
  define("JOB_CONTRACT_PERIOD", constant("JOB" . $suffix . "_CONTRACT_PERIOD"));
  define("JOB_PROBATION_PERIOD", constant("JOB" . $suffix . "_PROBATION_PERIOD"));
  define("JOB_PLACE_OF_WORK", constant("JOB" . $suffix . "_PLACE_OF_WORK"));
  define("JOB_WORKING_HOURS", constant("JOB" . $suffix . "_WORKING_HOURS"));
  define("JOB_BREAK_TIME", constant("JOB" . $suffix . "_BREAK_TIME"));
  define("JOB_HOLIDAYS", constant("JOB" . $suffix . "_HOLIDAYS"));
  define("JOB_OVERTIME_WORK", constant("JOB" . $suffix . "_OVERTIME_WORK"));
  define("JOB_WAGE", constant("JOB" . $suffix . "_WAGE"));
  define("JOB_INSURANCE", constant("JOB" . $suffix . "_INSURANCE"));
  define("JOB_SMOKING", constant("JOB" . $suffix . "_SMOKING"));
  define("JOB_APPLICATION_QUALIFICATIONS", constant("JOB" . $suffix . "_APPLICATION_QUALIFICATIONS"));
  define("JOB_APPEAL_TITLE", constant("JOB" . $suffix . "_APPEAL_TITLE"));
  define("JOB_APPEAL_TEXT", constant("JOB" . $suffix . "_APPEAL_TEXT"));
  define("JOB_BENEFITS_TITLE", constant("JOB" . $suffix . "_BENEFITS_TITLE"));
  define("JOB_BENEFITS_TEXT", constant("JOB" . $suffix . "_BENEFITS_TEXT"));
  define("JOB_OTHER_TITLE", constant("JOB" . $suffix . "_OTHER_TITLE"));
  define("JOB_OTHER_TEXT", constant("JOB" . $suffix . "_OTHER_TEXT"));

  define( "PAGE_TITLE" , '【' . JOB_TYPE . '】' . JOB_DESCRIPTION . '：' . JOB_CATCHCOPY) ;
  define( "PAGE_DESC" , DATA_NAME . 'の採用サイト内、【' . JOB_TYPE . '】' . JOB_DESCRIPTION .'の募集要項ページです。募集要項詳細や求人のアピールポイントなどご覧いただけます。') ;
?>
<?php
  // $plugIn__css = array('');
  // $plugIn__js = array('');
  // $js = array('');
?>
<?php
  include($_SERVER['DOCUMENT_ROOT'].'/head.php');
  echo "\n";
?>

<?php
$css__url = $_SERVER['DOCUMENT_ROOT']. '/css/' . PAGE_PASS .'.css';
// CSSファイルが存在するかチェックする
if (file_exists($css__url)) {
    echo '<link rel="stylesheet" href="/css/'. PAGE_PASS .'.css">';
} else {
    echo '<!-- ページ固有のCSSはありません -->'."\n";
}
?>

<?php

$jobWorkingConditions = [
  ['業務内容' => get_defined_or_default("JOB_DESCRIPTION"), '契約期間' => get_defined_or_default("JOB_CONTRACT_PERIOD"), '試用期間' => get_defined_or_default("JOB_PROBATION_PERIOD"), '就業場所' => get_defined_or_default("JOB_PLACE_OF_WORK"), '就業時間' => get_defined_or_default("JOB_WORKING_HOURS"), '休憩時間' => get_defined_or_default("JOB_BREAK_TIME"), '休日' => get_defined_or_default("JOB_HOLIDAYS"), '時間外労働' => get_defined_or_default("JOB_OVERTIME_WORK"), '賃金' => get_defined_or_default("JOB_WAGE"), '応募資格' => get_defined_or_default("JOB_APPLICATION_QUALIFICATIONS"), '加入保険' => get_defined_or_default("JOB_INSURANCE"), '受動喫煙防止措置' => get_defined_or_default("JOB_SMOKING")],
];

$hasValues = false;
foreach ($jobWorkingConditions as $recruit) {
    foreach ($recruit as $val) {
        if (!empty($val)) {
            $hasValues = true;
            break 2; // 両方のforeachループを抜ける
        }
    }
}

// JOB_MINIMUM_WAGE と JOB_MAXIMUM_WAGE の値を取得
$min = (float) JOB_MINIMUM_WAGE;
$max = (float) JOB_MAXIMUM_WAGE;
$salary = format_salary($min, $max);

// 追加： minValue と maxValue の設定  
$minValue = ($min === 0.0 && $max !== 0.0) ? $max : $min; 
$maxValue = ($max === 0.0 && $min !== 0.0) ? $min : $max; 
if ($min === 0.0 && $max === 0.0) { 
$minValue = 0;  
$maxValue = 0;  
}

$type_of_salary = '';
if (JOB_WORKING_TIME === 'FULL_TIME') {
  $type_of_salary = 'MONTH';
} elseif (JOB_WORKING_TIME === 'PART_TIME') {
  $type_of_salary = 'HOUR';
}
?>
<!-- ▼タグいれる場所 -->
<script type="application/ld+json">
{
"@context": "http://schema.org",
"@type": "JobPosting",
"title": "<?php echo '【' . JOB_TYPE . '】' . JOB_DESCRIPTION . '募集！' ; ?>",
"hiringOrganization": "<?php echo DATA_COMPANY ;?>",
"jobLocation": {
  "@type": "Place",
  "address": "<?php echo DATA_ADDRESS_REGION ;?><?php echo DATA_ADDRESS_LOCALITY ;?><?php echo DATA_STREET_ADDRESS ;?>"
},
"datePosted": "<?php echo date("Y-m-d") ;?>",
"baseSalary": {
  "@type": "MonetaryAmount",
  "currency": "JPY",
  "value": {
    "@type": "QuantitativeValue",
    "minValue": "<?php echo $minValue; ?>",
    "maxValue": "<?php echo $maxValue; ?>",
    "unitText": "<?php echo $type_of_salary ;?>"
  }
},
"description": "
<?php if ( defined( 'DATA_JOB_MESSAGE' ) && DATA_JOB_MESSAGE !== "") : ?>
<?php echo DATA_JOB_MESSAGE ;?><br>
<?php endif; ?>
<?php
  foreach ($jobWorkingConditions as $recruit) {
    foreach ($recruit as $key => $val) {
      if (!empty($val)) {
        echo '<br>--------------------------------<br>';
        echo '&nbsp;&nbsp;' . $key . '<br>';
        echo '--------------------------------<br>';
        echo '<br>' . $val . '<br>';
      }
    }
  }
?>
<?php if (defined( 'DATA_TEL' ) && DATA_TEL !== "") : ?>
お気軽に下記までご連絡ください！<br>
TEL.<?php echo DATA_TEL ; ?><br>
<?php endif; ?>
<br>
採用サイトからご応募ください↓<br>
<?php echo DOMAIN ; ?><br>
",
"employmentType": "<?php echo JOB_WORKING_TIME ; ?>"
}
</script>

<!-- ▼タグいれる場所 -->
<!-- ▲タグいれる場所 -->

</head>

<body class="p-<?php echo PAGE_PASS ;?> p-r">


<!--  -----------------------------------------
  SVG
------------------------------------------  -->
<?php
  include($_SERVER['DOCUMENT_ROOT'].'/svg.php');
  echo "\n";
?>


<div class="body-bg"><span></span></div>


<!--  -----------------------------------------
  HEADER
------------------------------------------  -->
<?php
  include($_SERVER['DOCUMENT_ROOT'].'/header.php');
  echo "\n";
?>


<main class="p-r">

<section class="recruit-heading w-l-sp w-s-tpc pt-120-sp pt-190-tpc">
  <p class="di animation mask-bg"><span class="bgc-base db fc-fff pl-5 ptb-5 pr-10 target-cts">【<?php echo JOB_TYPE ;?>】<?php echo JOB_DESCRIPTION ;?></span></p>
  <h1 class="fs-28 mt-25 l-15 animation mask-bg"><span class="target-cts"><?php echo JOB_CATCHCOPY ;?></span></h1>
  <ul class="fi-container fw a-c fc-base g-r-10 g-c-20 mt-15 animation op td-03">
    <li class="f-container a-c j-c g-10">
      <p class="bs-1 bc-base prl-10 ptb-5">雇用形態</p>
      <p><?php echo JOB_TYPE ;?></p>
    </li>
    <li class="f-container a-c j-c g-10">
      <p class="bs-1 bc-base prl-10 ptb-5">給与</p>
      <p>
        <?php 
          if (JOB_WORKING_TIME === 'FULL_TIME'){
            echo '月給 ';
          }else{
            echo '時給 ';
          }
          echo $salary;
        ;?>
      </p>
    </li>
  </ul>
</section>

<?php if ((defined( 'JOB_APPEAL_TEXT' ) && JOB_APPEAL_TEXT !== "") || (defined( 'JOB_BENEFITS_TEXT' ) && JOB_BENEFITS_TEXT !== "") || (defined( 'JOB_OTHER_TEXT' ) && JOB_OTHER_TEXT !== "")) : ?>
<section class="recruit-appeal w-l-sp w-s-tpc pt-40">
  <ul class="recruit-appeal-list g-container g-20 fc-fff l-15 animation op td-03">
    <?php if (defined( 'JOB_APPEAL_TEXT' ) && JOB_APPEAL_TEXT !== "") : ?>
    <li class="recruit-appeal-item bgc-base1 ptb-30 prl-40">
      <h2 class="fs-20 pb-20"><?php echo JOB_APPEAL_TITLE ;?></h2>
      <p><?php echo JOB_APPEAL_TEXT ;?></p>
    </li>
    <?php endif; ?>
    <?php if (defined( 'JOB_BENEFITS_TEXT' ) && JOB_BENEFITS_TEXT !== "") : ?>
    <li class="recruit-appeal-item bgc-base1 ptb-30 prl-40">
      <h2 class="fs-20 pb-20"><?php echo JOB_BENEFITS_TITLE ;?></h2>
      <p><?php echo JOB_BENEFITS_TEXT ;?></p>
    </li>
  <?php endif; ?>
  <?php if (defined( 'JOB_OTHER_TEXT' ) && JOB_OTHER_TEXT !== "") : ?>
    <li class="recruit-appeal-item bgc-base1 ptb-30 prl-40">
      <h2 class="fs-20 pb-20"><?php echo JOB_OTHER_TITLE ;?></h2>
      <p><?php echo JOB_OTHER_TEXT ;?></p>
    </li>
  <?php endif; ?>
  </ul>
  <div class="recruit-next p-r animation pt-m">
  </div>
</section>
<?php endif; ?>

<?php if ($hasValues) : ?>
<section class="recruit w-l-sp w-s-tpc pt-m">

  <div class="t-c pb-50 animation op">
    <h2 class="fs-36 en fc-base l-15">Recruit</h2>
    <p class="fw-b mt-10-pc mt-5-sp">募集要項</p>
  </div>

  <div class="recruit-data l-15 animation op">

<?php foreach ($jobWorkingConditions as $recruit) : ?>
<?php foreach ($recruit as $key => $val) : ?>
<?php if (!empty($val)) : ?>
<dl class="f-container">
  <dt class="fs-16 fw-b"><span><?php echo $key; ?></span></dt>
  <dd><span><?php echo $val; ?></span></dd>
</dl>
<?php endif; ?>
<?php endforeach; ?>
<?php endforeach; ?>

  </div>

</section>
<?php endif; ?>


<!--  -----------------------------------------
  ENTRY
------------------------------------------  -->
<?php
  include($_SERVER['DOCUMENT_ROOT'].'/entry_section.php');
  echo "\n";
?>


<!--  -----------------------------------------
  RECRUITMENT TYPE
------------------------------------------  -->
<?php

$visibleItems = [];

foreach ($recruitments as $recruitment) {
    if ((defined($recruitment['desc']) && constant($recruitment['desc']) !== "") || 
        (defined($recruitment['catchcopy']) && constant($recruitment['catchcopy']) !== "") || 
        (defined($recruitment['min']) && constant($recruitment['min']) !== "") || 
        (defined($recruitment['max']) && constant($recruitment['max']) !== "")) {
        $visibleItems[] = $recruitment;
    }
}

if (count($visibleItems) >= 2): ?>
<section class="recruitment-type p-r z-100">
  
  <div class="recruitment-type-inner w-l-pc pt-xs pb-s of-hidden bgc-base2 bs-t-4 bc-base">

    <div class="t-c pb-50">
      <h2 class="fs-36 en fc-base l-15">Recruitment Type</h2>
      <p class="fw-b mt-10-pc mt-5-sp">募集職種</p>
    </div>

    <div class="recruitment-type-box pl-s-sp">
      <div class="of-x-scroll-sp">

        <ul class="recruitment-type-list g-container-3-pc f-container-sp g-20">
<?php 
foreach ($visibleItems as $recruitment): 
  $min = (float) constant($recruitment['min']);
  $max = (float) constant($recruitment['max']);
  $salary = format_salary($min, $max);

  $recruitment_id = constant($recruitment['value']);
  if ($recruitment_id === PAGE_PASS) {
    continue;
  }
?>
          <li id="<?php echo $recruitment_id; ?>" class="recruitment-type-item bgc-fff br-10 of-hidden fs">
            <div class="item-upper ptb-25 prl-20 bgc-base3 bs-b-4 bc-base2">
              <h3 class="fs-20 l-15"><?php echo constant($recruitment['catchcopy']); ?></h3>
              <p class="fc-base mt-5 fw-b"><?php echo constant($recruitment['desc']); ?></p>
            </div>
            <div class="item-lower p-20">
              <div class="g-container-1 g-5 l-15">
                <dl class="f-container">
                  <dt class="f-container w-90 nw a-c j-c fs ptb-10 bgc-base1 fc-fff">雇用形態</dt>
                  <dd class="f-item ptb-10 prl-15"><?php echo constant($recruitment['type']); ?></dd>
                </dl>
                <dl class="f-container">
                  <dt class="f-container w-90 nw a-c j-c fs ptb-10 bgc-base1 fc-fff">給与</dt>
                  <dd class="f-item ptb-10 prl-15">
                    <?php 
                      if (constant($recruitment['time']) === 'FULL_TIME'){
                        echo '月給 ';
                      }else{
                        echo '時給 ';
                      }
                      echo $salary;
                    ;?>
                  </dd>
                </dl>
              </div>
              <div class="highlight-btn mt-20">
                <a href="<?php echo constant($recruitment['value']); ?>.php" class="fc-fff h-50 bgc-base br-10 f-container j-c a-c bs-2 bc-base scale-105">詳しく見る</a>
              </div>
            </div>
          </li>
<?php endforeach; ?>
        </ul>

      </div>
    </div>

  </div>

</section>
<?php endif; ?>

</main>


<!--  -----------------------------------------
  FOOTER
------------------------------------------  -->
<?php
  include($_SERVER['DOCUMENT_ROOT'].'/footer.php');
  echo "\n";
?>
</body>
</html>
